TYPE
  LOGLEVEL : (CRITICAL, WARNING, INFO, DEBUG) := INFO;
END_TYPE

FUNCTION_BLOCK LOGGER
  VAR_INPUT
    TRIG : BOOL;
    MSG : STRING;
    LEVEL : LOGLEVEL := INFO;
  END_VAR
  VAR
    TRIG0 : BOOL;
  END_VAR

  IF TRIG AND NOT TRIG0 THEN
  {{
   LogMessage(GetFbVar(LEVEL),(char*)GetFbVar(MSG, .body),GetFbVar(MSG, .len));
  }}
  END_IF;
  TRIG0:=TRIG;
END_FUNCTION_BLOCK



FUNCTION_BLOCK python_eval
  VAR_INPUT
    TRIG : BOOL;
    CODE : STRING;
  END_VAR
  VAR_OUTPUT
    ACK : BOOL;
    RESULT : STRING;
  END_VAR
  VAR
    STATE : DWORD;
    BUFFER : STRING;
    PREBUFFER : STRING;
    TRIGM1 : BOOL;
    TRIGGED : BOOL;
  END_VAR

  {extern void __PythonEvalFB(int, PYTHON_EVAL*);__PythonEvalFB(0, data__);}
END_FUNCTION_BLOCK

FUNCTION_BLOCK python_poll
  VAR_INPUT
    TRIG : BOOL;
    CODE : STRING;
  END_VAR
  VAR_OUTPUT
    ACK : BOOL;
    RESULT : STRING;
  END_VAR
  VAR
    STATE : DWORD;
    BUFFER : STRING;
    PREBUFFER : STRING;
    TRIGM1 : BOOL;
    TRIGGED : BOOL;
  END_VAR

  {extern void __PythonEvalFB(int, PYTHON_EVAL*);__PythonEvalFB(1,(PYTHON_EVAL*)(void*)data__);}
END_FUNCTION_BLOCK

FUNCTION_BLOCK python_gear
  VAR_INPUT
    N : UINT;
    TRIG : BOOL;
    CODE : STRING;
  END_VAR
  VAR_OUTPUT
    ACK : BOOL;
    RESULT : STRING;
  END_VAR
  VAR
    py_eval : python_eval;
    COUNTER : UINT;
    ADD10_OUT : UINT;
    EQ13_OUT : BOOL;
    SEL15_OUT : UINT;
    AND7_OUT : BOOL;
  END_VAR

  ADD10_OUT := ADD(COUNTER, 1);
  EQ13_OUT := EQ(N, ADD10_OUT);
  SEL15_OUT := SEL(EQ13_OUT, ADD10_OUT, 0);
  COUNTER := SEL15_OUT;
  AND7_OUT := AND(EQ13_OUT, TRIG);
  py_eval(TRIG := AND7_OUT, CODE := CODE);
  ACK := py_eval.ACK;
  RESULT := py_eval.RESULT;
END_FUNCTION_BLOCK


PROGRAM Foerderband
  VAR
    Start : BOOL;
    SensorLinks : BOOL;
    SensorRechts : BOOL;
    MotorOn : BOOL;
    MotorDir : BOOL;
    Barcode : BOOL;
    LedOK : BOOL;
    BlinkLed : BOOL;
  END_VAR
  VAR
    TimerBlink : TON;
    TimeerMotor : TON;
    TimerBlinkReady : BOOL := FALSE;
    TimerMotorReady : BOOL := FALSE;
    State : INT := 0;
  END_VAR

  (* Programm Transportband *)
  (* LED blinken lassen *)
    TimerBlink(IN:= NOT TimerBlink.Q,PT:=T#500ms,Q=>TimerBlinkReady);
    
    IF TimerBlinkReady THEN 
      BlinkLed:=NOT BlinkLed;
    END_IF;


  (* State Machine fuer das Transportband *)
  (* Wenn der Start Taster und der Kontakt SensorLinks *)
  (* betaetigt werden startet das Transportband nach rechts *)
  (* wenn die rechte Position erreicht ist stoppt das Band *)
  (* und wartet 5 Sekunden , dabei wird die Leitung Barcode geschaltet*)
  (* Danach faehrt es wieder nach links bis SensorLinks betätigt wird *) 
    CASE State OF
         (* Startbedingung  *) 
         0: IF (Start AND SensorLinks) THEN
          State:=10;
        END_IF;
      (* Rechte Position erreicht *)
      10: IF SensorRechts THEN
          State:=20;
         END_IF;
      (* 5 Sekunden warten dann nach links *)
      20:TimeerMotor(IN:= NOT TimeerMotor.Q,PT:=T#5S,Q=>TimerMotorReady);
          IF TimerMotorReady THEN
            State:=30;
          END_IF;
      (* Motor wieder nach links *)
      30: IF SensorLinks THEN
          State:=0;
          END_IF;
    END_CASE;  

  (* Schalten der Motor und Barcode Leitungen *)
      
    CASE State OF
      0:MotorOn:=FALSE; MotorDir:=FALSE;LedOK:=0;
      10:MotorOn:=TRUE; MotorDir:=TRUE;
      20:MotorOn:=FALSE; MotorDir:=FALSE;Barcode:=1;
      30:MotorOn:=TRUE; MotorDir:=FALSE;Barcode:=0;LedOK:=1;
    END_CASE; 
    
END_PROGRAM


CONFIGURATION Config0

  RESOURCE Res0 ON PLC
    TASK task0(INTERVAL := T#20ms,PRIORITY := 0);
    PROGRAM instance0 WITH task0 : Foerderband;
  END_RESOURCE
END_CONFIGURATION
